<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van COMT_IN999998NL - Log Query</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <pattern is-a="attentionLine" id="COMT_IN999998NL-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId/hl7:value"/>
        <param name="attentionLineOptional" value="'false'"/>
    </pattern>
    
    <pattern is-a="transmission-wrapper" id="COMT_IN999998NL-wrapper">
        <param name="element" value="hl7:COMT_IN999998NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="COMT_IN999998NL-controlAct">
        <param name="element" value="hl7:COMT_IN999998NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:COMT_IN999998NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:COMT_IN999998NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'"
                >In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:COMT_IN900010NL/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:COMT_IN900010NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- responseModalityCode -->
        <rule context="hl7:responseModalityCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='R'"
                >queryByParameter/responseModalityCode moet waarde 'R' hebben.</assert>
        </rule>
        <!-- responseModalityCode -->
        <rule context="hl7:responsePriorityCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='I'"
                >queryByParameter/responsePriorityCode moet waarde 'I' hebben.</assert>
        </rule>
        <!-- actDataType -->
        <rule context="hl7:actDataType/hl7:value">
            <extends rule="CD"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.4'"
                >De code is niet van het ActRegistryCodeNL domein (2.16.840.1.113883.2.4.15.4)</assert>
        </rule>
        <!-- initiatorInteractionId -->
        <rule context="hl7:initiatorInteractionId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.1.6'"
                >OID root moet wijzen naar HL7 interactie-id's '2.16.840.1.113883.1.6'.</assert>
        </rule>
        <!-- initiatorOverseerId -->
        <rule context="hl7:initiatorOverseerId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3'"
                >OID root moet wijzen naar het BSN of UZI-register.</assert>
        </rule>
        <!-- initiatorOverseerOrganisationId-->
        <rule context="hl7:initiatorOverseerOrganisationId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.528.1.1007.3.3'"
                >OID root moet wijzen naar een URA.</assert>
        </rule>
        <!-- initiatorOverseerRoleCode -->
        <rule context="hl7:initiatorOverseerRoleCode/hl7:value">
            <extends rule="CE"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.111'"
                >Code moet een CIBG rolcode zijn (2.16.840.1.113883.2.4.15.111).</assert>
        </rule>
        <!-- initiatorSendingApplicationId -->
        <rule context="hl7:initiatorSendingApplicationId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6'"
                >Root OID van initiatorSendingApplicationId moet 2.16.840.1.113883.2.4.6.6 zijn.</assert>
        </rule>
        <!-- patientId -->
        <rule context="hl7:patientId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
                >OID root van patientID wijst niet naar BSN-register</assert>
        </rule>
        <!-- respondingAuthorId -->
        <rule context="hl7:respondingAuthorId/hl7:value">
            <extends rule="II"/>
            <report role="warning" test="."
                >respondingAuthorId niet gebruiken</report>
            <assert role="error" test="@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3'"
                >OID root moet wijzen naar het BSN of UZI-register.</assert>
        </rule>
        <!-- respondingAuthorOrganisationId -->
        <rule context="hl7:respondingAuthorOrganisationId/hl7:value">
            <extends rule="II"/>
            <report role="warning" test="."
                >respondingAuthorOrganisationId niet gebruiken</report>
            <assert role="error" test="@root='2.16.528.1.1007.3.3'"
                >OID root moet wijzen naar een URA.</assert>
        </rule>
        <!-- respondingAuthorRoleCode -->
        <rule context="hl7:respondingAuthorRoleCode/hl7:value">
            <extends rule="CE"/>
            <report role="warning" test="."
                >respondingAuthorRoleCode niet gebruiken</report>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.111'"
                >Code moet een CIBG rolcode zijn (2.16.840.1.113883.2.4.15.111).</assert>
        </rule>
        <!-- respondingSendingApplicationId -->
        <rule context="hl7:respondingSendingApplicationId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6'"
                >Root OID van respondingSendingApplicationId moet 2.16.840.1.113883.2.4.6.6 zijn.</assert>
        </rule>
    </pattern>
</schema>
